/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ntfy;

import com.ibm.hwmca.fw.ntfy.DescriptiveObject;
import com.ibm.hwmca.fw.ntfy.NotificationService;
import com.ibm.hwmca.fw.ntfy.SourceSinkLinkChain;
import com.ibm.hwmca.fw.ntfy.Startable;
import com.ibm.hwmca.fw.ntfy.eventchain.ChainLink;
import com.ibm.hwmca.fw.ntfy.eventchain.ChainedObject;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SourceSinkLink
extends DescriptiveObject
implements Serializable,
Startable {
    static final long serialVersionUID = -4572128743356561317L;
    private static final String TRACE_MASKT = "XNTYLNKT";
    private static final String TRACE_MASKF = "XNTYLNKF";
    private static final String TRACE_MASKD = "XNTYLNKD";
    private Set _sources;
    private Set _sinks;
    private SourceSinkLinkChain _chainLink;

    SourceSinkLink() {
    }

    public SourceSinkLink(String name, String description, Set sources, Set sinks) {
        super(name, description);
        Trace.trace(TRACE_MASKT, "-> SourceSinkLink(" + name + ")");
        this._sources = sources == null ? new HashSet() : sources;
        this._sinks = sinks == null ? new HashSet() : sinks;
        this._chainLink = new SourceSinkLinkChain(this);
        Trace.trace(TRACE_MASKT, "<- SourceSinkLink");
    }

    public void start() throws Exception {
        Trace.trace(TRACE_MASKT, "-> start()");
        this._chainLink = new SourceSinkLinkChain(this);
        Trace.trace(TRACE_MASKT, "<- start");
    }

    public void stop() throws Exception {
        this._chainLink = null;
    }

    public boolean isStarted() {
        return this._chainLink != null;
    }

    public void setDeleted() {
        if (this._chainLink != null) {
            this._chainLink.delete();
        }
    }

    public void setReplaced(ChainedObject replacement) {
        if (this._chainLink != null) {
            this._chainLink.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSources() {
        Set set = this._sources;
        synchronized (set) {
            this.cleanup(this._sources);
        }
        return this._sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSinks() {
        Set set = this._sinks;
        synchronized (set) {
            this.cleanup(this._sinks);
        }
        return this._sinks;
    }

    private void cleanup(Set chainedObjects) {
        Iterator i = chainedObjects.iterator();
        ChainedObject object = null;
        ChainedObject current = null;
        HashSet<ChainedObject> additions = new HashSet<ChainedObject>();
        while (i.hasNext()) {
            object = (ChainedObject)i.next();
            if (object == (current = object.getCurrent())) continue;
            i.remove();
            if (current == null) continue;
            additions.add(current);
        }
        chainedObjects.addAll(additions);
    }

    public boolean isEnabled() {
        boolean active = NotificationService.getManager().isEnabled() && super.isEnabled();
        Trace.trace(TRACE_MASKF, "isActive:  " + active);
        return active;
    }

    private String stringFromSet(Set set) {
        if (set == null) {
            return "empty";
        }
        StringBuffer out = new StringBuffer();
        Iterator items = set.iterator();
        while (items.hasNext()) {
            out.append(((DescriptiveObject)items.next()).getName());
            if (!items.hasNext()) continue;
            out.append(",");
        }
        return out.toString();
    }

    public StringBuffer parms() {
        StringBuffer buff = super.parms();
        buff.append(", sources=");
        buff.append(this.stringFromSet(this._sources));
        buff.append(", sinks=");
        buff.append(this.stringFromSet(this._sinks));
        return buff;
    }

    public ChainLink getChainLink() {
        return new SourceSinkLinkChain(this);
    }
}

